IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_CLI_CONV_PBM_CONTROLE_CENTRALIZADO_NOTA_FISCAL]') 
					AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [DBO].[P_RC_CLI_CONV_PBM_CONTROLE_CENTRALIZADO_NOTA_FISCAL]
END
GO
 CREATE PROCEDURE P_RC_CLI_CONV_PBM_CONTROLE_CENTRALIZADO_NOTA_FISCAL @CD_EMP INT, @CD_FILIAL INT,@CD_NF INT,@CD_CTR_CENTRALIZADO INT
 AS
SET NOCOUNT ON;

DECLARE @CD_PROD INT
DECLARE @QT_IT MONEY
DECLARE @NR_NF INT

	DECLARE ProcPBMNotaFiscal CURSOR FAST_FORWARD
	FOR SELECT
		EST_NF_ENT_IT.CD_PROD,
		EST_NF_ENT_IT.QT_IT,
		EST_NF_ENT.NR_NF
	FROM
		EST_NF_ENT_IT INNER JOIN EST_NF_ENT ON
		EST_NF_ENT_IT.CD_EMP = EST_NF_ENT.CD_EMP AND
		EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT.CD_FILIAL AND
		EST_NF_ENT_IT.CD_NF = EST_NF_ENT.CD_NF 
	WHERE
		EST_NF_ENT_IT.CD_EMP = @CD_EMP
		AND EST_NF_ENT_IT.CD_FILIAL = @CD_FILIAL
		AND EST_NF_ENT_IT.CD_NF = @CD_NF

	OPEN ProcPBMNotaFiscal;
	FETCH NEXT FROM ProcPBMNotaFiscal INTO @CD_PROD,
										   @QT_IT,
										   @NR_NF;
	WHILE @@FETCH_STATUS = 0
		BEGIN
			PRINT 'Filial '+CONVERT(VARCHAR(10), @CD_FILIAL)+' '+CONVERT(VARCHAR, GETDATE(), 108);
		
			EXEC P_RC_CLI_CONV_PBM_CONTROLE_CENTRALIZADO_CPL @CD_CTR_CENTRALIZADO,@CD_PROD,@QT_IT,@NR_NF,@CD_FILIAL

	FETCH NEXT FROM ProcPBMNotaFiscal INTO @CD_PROD,
								       @QT_IT,
									   @NR_NF;
	END;
PRINT 'Concluido.';
CLOSE ProcPBMNotaFiscal;
DEALLOCATE ProcPBMNotaFiscal;






